package sk.kosice.konto.kknotificationservice.domain.common.error;

import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.INTERNAL;

public enum ServiceErrorCode implements ErrorCode {
  UNKNOWN_SERVICE_ERROR(INTERNAL, "Please contact technical support."),
  EXTERNAL_SYSTEM_ERROR(INTERNAL, "Please contact technical support.");

  private final ErrorCodeType type;
  private final String template;

  ServiceErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
