import React from 'react';
import { useTranslations } from 'next-intl';
import { date, MessageTag as MessageTagType } from '@/utils';
import { MessageTags } from '@/components';

interface MessageHeaderProps {
  title: string;
  senderName: string;
  createdAt: string;
  tags: MessageTagType[];
  locale: string;
}

const MessageHeader: React.FC<MessageHeaderProps> = ({ title, senderName, createdAt, tags, locale }) => {
  const t = useTranslations('messages');
  return (
    <div className="p-5 border-b border-neutral-300">
      <div className="flex justify-between gap-5">
        <h3>{title}</h3>
        <span>{date(createdAt, locale)}</span>
      </div>
      <p className="mt-2">
        <b>{t('sender')}: </b>
        <span>{senderName}</span>
      </p>
      <MessageTags tags={tags} />
    </div>
  );
};

export default MessageHeader;
