import React from 'react';
import { cn } from '@/utils';

interface HeadingProps extends React.HTMLAttributes<HTMLDivElement> {
  children: React.ReactNode;
}

const Heading: React.FC<HeadingProps> = ({ className, ...props }) => (
  <div className={cn('mb-5 tb2:my-7', className)} {...props} />
);

export default Heading;
