import { auth } from '@/auth';

export async function GET() {
  if (process.env.API_EP_USER_ENABLED !== 'true') {
    return new Response('Not found.', { status: 404 });
  }

  const session = await auth();

  if (!session) {
    return new Response('Permission denied.', { status: 403 });
  }

  return Response.json({ session });
}
