import React from 'react';
import ReactDOM from 'react-dom';

import { ErrorDialog, PrimaryButton } from '@/lib/idsk';
import { useTranslations } from 'next-intl';
import { logout } from '@/utils';
import { NewReleasesIcon } from '@/lib/idsk';

const VersionCheckDialog: React.FC<{ isOpen: boolean }> = ({ isOpen }) => {
  const t = useTranslations('utils');

  return ReactDOM.createPortal(
    <ErrorDialog
      className="error-dialog--custom"
      opened={isOpen}
      title={t('new_version_availible')}
      img={<NewReleasesIcon className="text-primary-medium w-[6rem] h-[6rem]" />}
    >
      <p className="idsk-text-body text-neutral-700">{t('new_version_description')}</p>
      <PrimaryButton
        fullWidth
        onClick={() => {
          logout('/uvod');
        }}
      >
        {t('reload_again')}
      </PrimaryButton>
    </ErrorDialog>,
    document.getElementsByTagName('body')[0]
  );
};

export default VersionCheckDialog;
