import React from 'react';
import { MessageTag as MessageTagType } from '@/utils';
import { MessageTag } from '@/components';

interface MessageTagsProps {
  tags: any[];
}

const MessageTags: React.FC<MessageTagsProps> = ({ tags }) => (
  <>
    {tags.length > 0 && (
      <div className="flex flex-wrap gap-2.5 mt-5">
        {tags.map((tag: MessageTagType, index: number) => (
          <MessageTag key={`tag-${tag.color}-${tag.value}-${index + 1}`} color={tag.color} size="small">
            {tag.value}
          </MessageTag>
        ))}
      </div>
    )}
  </>
);

export default MessageTags;
