export interface Fault {
  serviceId: string;
  faultCode: string;
  faultMessage: string;
  faultMessageFormat: string[];
}

export interface ApiError {
  correlationId: string;
  fault: Fault[];
}

export interface SimpleApiError {
  correlationId: string;
  serviceId: string;
  faultCode: string;
  faultMessage: string;
  faultMessageParams: string[];
}

export type RequestError = {
  status: number;
  statusText: string;
  message: string;
  correlationId: string;
  fault: Fault[];
};

export type Ok<T> = {
  data: T;
  error: undefined;
};

export type Err = {
  status: number;
  data: undefined;
  error: RequestError;
};

export type Result<T> = Ok<T> | Err;

export type Page<T> = {
  items: T[];
  page: number;
  pageSize: number;
  totalCount: number;
};

export interface IUser {
  id: string;
  name: string;
  surname: string;
  email: string;
  created: number;
  modified: number;
  pin: string;
}

export interface Identity {
  kid: string;
  qaaReg: string;
  pin: string;
  category: string;
  emails: string[];
  emailPreferred?: string;
  phonePreferred?: string;
  phones: string[];
  givenName: string;
  surname: string;
  title: string;
  ibans: string[];
  created: number;
  modified: number;
  expRegCode: number;
  isActive: boolean;
}

export interface Address {
  aid: string;
  type: string;
  street1: string;
  censusNumber: string;
  orientationNumber: string;
  city: string;
  state: string;
  postalCode: string;
  created: number;
  modified: number;
  isActive: boolean;
}

export interface Profile {
  identity: Identity;
  addresses: Address[];
}

export interface ProceedingSource {
  id: string;
  type: string;
  key: string;
  value: string;
  metadata?: Omit<ProceedingSource[], 'metadata'>;
}

export interface Proceeding {
  id: string;
  parentId: string;
  type: string;
  category: string;
  subcategories: string[];
  title: string;
  decs: string;
  state: string;
  statuses: string[];
  created: number;
  modified: number;
  finished: number;
  contactPerson: string;
  paid: number;
  total: number;
  sources: ProceedingSource[];
}

export interface Proceedings {
  proceedings: Proceeding[];
}

export interface MessageTag {
  color: string;
  value: string;
}

export interface Message {
  id: string;
  senderName: string;
  title: string;
  tags: MessageTag[];
  createdAt: string;
}

export interface Pagination {
  size: number;
  start: number;
  limit: number;
}

export interface FamilyIdentity {
  kid: string;
  familyConnection: number;
  qaaReg: string;
  category: number;
  givenName: string;
  surname: string;
  dateOfBird: number;
  dateOfDeath: number;
  created: number;
  modified: number;
  isActive: boolean;
}

export interface FamilyAddress {
  aid: string;
  type: string;
  street1: string;
  censusNumber: string;
  orientationNumber: string;
  city: string;
  state: string;
  postalCode: string;
  latitude: number;
  longitude: number;
  created: number;
  modified: number;
  isActive: boolean;
}

export interface Family {
  pagination: Pagination;
  profiles: [
    {
      identity: FamilyIdentity;
      addresses: FamilyAddress[];
    }
  ];
}

export interface MessageActionMetadata {
  id: string;
  type: string;
  key: string;
  value: string;
}

export interface MessageAction {
  title: string;
  desc: string;
  type: string | number;
  value: string;
  metadata: MessageActionMetadata[];
}

export interface Subscription {
  id: string;
  isEmailEnabled: boolean;
  recipientKid: string;
  topic: {
    id: string;
    name: string;
    description: string;
  };
  organization: {
    id: string;
    name: string;
  };
}

export interface Organization {
  id: string;
  name: string;
  description: string;
  isCityDistrict: boolean;
}

export interface MessageDetail {
  id: string;
  senderName: string;
  title: string;
  topic: { id: string; name: string };
  tags: MessageTag[];
  createdAt: string;
  senderId: string;
  bodyType: string;
  body: string;
  bodyShort: string;
  actions: MessageAction[];
  locations: string[];
}

export interface Pets {
  pagination: Pagination;
  pets: {
    id: string;
    evc: string;
    kind: string;
    name: string;
    breed: string;
    age: number;
    regDate: number;
    address: {
      aid: string;
      type: string;
      street1: string;
      city: string;
      state: string;
      postalCode: string;
      created: number;
      modified: number;
      isActive: boolean;
    };
    fromShelder: boolean;
    adopted: boolean;
    holdingPlaceType: string;
    holdingPlace: string;
    holdingPurposeType: string;
    legalRelationShip: string;
    created: number;
    modified: number;
  }[];
}

export interface Flat {
  flatNumber: string;
  entaranceNumber: string;
  flatArea: number;
  shareOfSpace: string;
  constructionRegistryNumber: string;
  coOwner: any[];
  coOwnership: any[];
  prid: string;
  type: string;
  relationship: number;
  region: string;
  municipality: string;
  district: string;
  cadastralDistrict: string;
  created: number;
  modified: number;
}

export interface Construction {
  parcelArea: number;
  constructionRegistryNumber: string;
  shareOfSpace: string;
  prid: string;
  type: string;
  relationship: number;
  ownershipDocNumber: string;
  region: string;
  municipality: string;
  district: string;
  cadastralDistrict: string;
  created: number;
  modified: number;
}

export interface Parcel {
  parcelArea: number;
  prid: string;
  type: string;
  ownershipDocNumber: string;
  region: string;
  municipality: string;
  district: string;
  cadastralDistrict: string;
  created: number;
  modified: number;
}

export interface PropertyTypes {
  flats: Flat[];
  constructions: Construction[];
  parcels: Parcel[];
}

export interface Properties {
  pagination: Pagination;
  properties: PropertyTypes[];
}
