'use client';

import { useSession } from 'next-auth/react';
import { useCallback, useState } from 'react';
import { Organization } from '@/utils';
import { useGetSubscriptions } from '@/hooks';

type SelectedOrganization = Organization & { type: 'edit' | 'delete' };

const useSubscriptions = () => {
  const { data } = useSession();
  const [selected, setSelected] = useState<SelectedOrganization | null>(null);

  const userId = data?.user.id || '';

  const query = useGetSubscriptions(userId);

  const onEdit = useCallback((item: Organization) => {
    setSelected({ ...item, type: 'edit' });
  }, []);

  const onDelete = useCallback((item: Organization) => {
    setSelected({ ...item, type: 'delete' });
  }, []);

  return {
    userId,
    query,
    onEdit,
    onDelete,
    selected,
    onCancelEdit: () => setSelected(null)
  };
};

export default useSubscriptions;
