package sk.kosice.konto.kkmessageservice.repository.topic.mapper;

import java.util.stream.Stream;
import org.jooq.Record;
import org.jooq.RecordMapper;
import sk.kosice.konto.kkmessageservice.domain.common.TriFunction;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ImmutableListOfTopics;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ImmutableTopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ListOfTopics;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.query.TopicListingQuery;
import sk.kosice.konto.kkmessageservice.repository.model.tables.records.TopicRecord;

public class JooqTopicRepositoryMapper {

  public static RecordMapper<Record, TopicEntity> topicRecordMapper() {
    return record -> {
      final var topicRecord = record.into(TopicRecord.class);

      return ImmutableTopicEntity.builder()
          .id(topicRecord.getId())
          .name(topicRecord.getName())
          .description(topicRecord.getDescription())
          .organizationId(topicRecord.getOrganizationId())
          .organizationName(topicRecord.getOrganizationName())
          .build();
    };
  }

  public static final TriFunction<Stream<Record>, Integer, TopicListingQuery, ListOfTopics>
      listingMapper =
          (records, totalCount, query) ->
              ImmutableListOfTopics.builder()
                  .page(query.page())
                  .pageSize(query.pageSize().value())
                  .totalCount(totalCount)
                  .addAllItems(records.map(record -> topicRecordMapper().map(record)).toList())
                  .build();
}
