package sk.kosice.konto.kkmessageservice.restapi.dto.message;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.NOT_REQUIRED;
import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.BodyType;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Location;

@JsonDeserialize(as = ImmutableMessageDetailResponse.class)
@JsonSerialize(as = ImmutableMessageDetailResponse.class)
@Value.Immutable
public interface MessageDetailResponse extends BaseMessageDto {

  @Schema(requiredMode = REQUIRED, example = "TEXT")
  @NotNull
  BodyType getBodyType();

  @Schema(requiredMode = REQUIRED, example = "Pekná dlhá správa")
  String getBody();

  @Schema(requiredMode = REQUIRED, example = "Pekná krátka správa")
  @NotBlank
  String getBodyShort();

  @Schema(
      requiredMode = NOT_REQUIRED,
      example =
          """
    [
        {
          "title": "1. Platba kartou online",
          "desc": "Najrýchlejší spôsob, ako zaplatiť miestnu daň, je priamo cez elektronickú platobnú bránu mesta. Pre rýchlu platbu kliknite na tlačidlo „Zaplať kartou“. Platba bude spracovaná okamžite.",
          "type": "OPEN_PAY_BY_CARD_URL",
          "value": "/pay/metadata",
          "metadata": [
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
              "type": "text",
              "key": "Platba za:",
              "value": "miestnu daň z nehnuteľnosti"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c4",
              "type": "price",
              "key": "Suma:",
              "value": "150.00"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c3",
              "type": "text",
              "key": "VARIABILNY_SYMBOL",
              "value": "150.00"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c2",
              "type": "text",
              "key": "IBAN",
              "value": "SK3112000000198742637541"
            }
          ]
        },
        {
          "title": "2. Platba bankovým prevodom alebo PAY by square",
          "desc": "Využite možnosť úhrady prostredníctvom svojho internet bankingu \\nalebo rýchlejšiu cestu skenovaním QR kódu nižšie.             \\n",
          "type": "SHOW_PAY_QR_CODE",
          "value": "",
          "metadata": [
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
              "type": "text",
              "key": "TITLE",
              "value": "Platobné údaje:"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c9",
              "type": "text",
              "key": "Platba za:",
              "value": "miestnu daň z nehnuteľnosti"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c7",
              "type": "price",
              "key": "Suma:",
              "value": "150.00"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c6",
              "type": "text",
              "key": "VARIABILNY_SYMBOL",
              "value": "150.00"
            },
            {
              "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c5",
              "type": "text",
              "key": "IBAN",
              "value": "SK3112000000198742637541"
            }
          ]
        }
      ]
  """)
  Optional<List<JsonNode>> getActions();

  @Schema(requiredMode = NOT_REQUIRED, example = "KOSICE_STARE_MESTO")
  List<Location> getLocations();
}
