package sk.kosice.konto.kkmessageservice.restapi.mapper;

import java.util.List;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.ImmutableOrganizationDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.ImmutableOrganizationListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.OrganizationDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.organization.OrganizationListResponse;

public class OrganizationResponseMapper {

  public static OrganizationDto map(OrganizationEntity entity) {
    return ImmutableOrganizationDto.builder()
        .id(entity.id())
        .isCityDistrict(entity.isCityDistrict())
        .name(entity.name())
        .description(entity.description())
        .build();
  }

  public static OrganizationListResponse map(List<OrganizationEntity> entities) {
    return ImmutableOrganizationListResponse.builder()
        .addAllItems(entities.stream().map(OrganizationResponseMapper::map).toList())
        .build();
  }
}
