import React from 'react';
import { SecondaryButton } from '@/lib/idsk';
import { useTranslations } from 'next-intl';
import Link from 'next/link';

type Props = {
  onHide: () => void;
};

export const CookieBannerNotification: React.FC<Props> = ({ onHide }) => {
  const t = useTranslations('cookies');
  return (
    <div>
      <p>
        {t.rich('youAcceptedCookies', {
          link: (chunks) => (
            <Link href="/cookies" className="idsk-link-m">
              {chunks}
            </Link>
          )
        })}
      </p>
      <SecondaryButton className="mt-2" onClick={onHide}>
        {t('hideMessage')}
      </SecondaryButton>
    </div>
  );
};
