'use client';

import React, { useMemo, useState } from 'react';
import { useSession } from 'next-auth/react';
import { logout } from '@/utils';
import { AvatarCircle, MenuButton, ModalSideBar, PrimaryButton, SecondaryButton, SwapHorizIcon } from '@/lib/idsk';
import Link from 'next/link';
import MobileNavigation from './MobileNavigation';

const UserHeader: React.FC = () => {
  const [isOpened, setIsOpened] = useState<boolean>(false);
  const { data } = useSession();

  const toggleOpen = () => {
    setIsOpened((p) => !p);
  };

  const user = useMemo(() => {
    return data?.user;
  }, [data]);

  return (
    <>
      {user && (
        <>
          <div className="hidden dm1:flex gap-5">
            <div className="text-right">
              <Link href="/organizacie" className="hover:underline">
                <b className="leading-4">{user.name}</b>
              </Link>
              {user.organization && <p className="text-right text-sm text-neutral-600">{user.organization.name}</p>}
            </div>
            <SecondaryButton onClick={() => logout()}>Odhlásiť sa</SecondaryButton>
          </div>

          <div className="dm1:hidden">
            <MenuButton
              opened={isOpened}
              toggleOpened={toggleOpen}
              openedTitle={'Zatvoriť'}
              closedTitle={'Menu'}
            ></MenuButton>
            <ModalSideBar opened={isOpened} toggleOpened={toggleOpen} heading="Menu">
              <div className="p-5">
                <div className="flex gap-4 items-center mb-5">
                  <AvatarCircle fullName={user.name} />
                  <div>
                    <b>{user.name}</b>
                    {user.organization && <span className="block text-neutral-600">{user.organization.name}</span>}
                  </div>
                </div>
                <Link href="/organizacie">
                  <SecondaryButton icon={<SwapHorizIcon />} onClick={() => logout()} fullWidth>
                    Zmeniť organizáciu
                  </SecondaryButton>
                </Link>
                <MobileNavigation user={data?.user} toggleOpen={toggleOpen} />
                <PrimaryButton onClick={() => logout()} fullWidth>
                  Odhlásiť sa
                </PrimaryButton>
              </div>
            </ModalSideBar>
          </div>
        </>
      )}
    </>
  );
};

export default UserHeader;
