'use client';

import { useNotificationsContext } from '@/context';
import { SnackbarProps } from '@/lib/idsk';

type Notification = Omit<SnackbarProps, 'open'>;

const useNotifications = () => {
  const { setNotifications } = useNotificationsContext();

  const notify = (notification: string | Notification) => {
    const snackbar: SnackbarProps = {
      open: true,
      autoHideDuration: 6000,
      closeButton: true,
      ...(typeof notification === 'string' ? { message: notification } : notification)
    };
    setNotifications((prevNotifications) => [...prevNotifications, snackbar]);
  };

  return notify;
};

export default useNotifications;
