import { signIn, signOut } from 'next-auth/react';

export const login = (lang = 'sk') => {
  signIn(
    'microsoft-entra-id',
    {
      callbackUrl: '/'
    },
    { ui_locales: lang }
  );
};

export const logout = (callbackUrl?: string) => {
  signOut({ callbackUrl: callbackUrl ?? '/prihlasenie' }).then(() => {
    if (typeof window !== 'undefined' && !!callbackUrl) {
      window.location.href = callbackUrl;
    }
  });
};
