package sk.kosice.konto.kkmessageservice.repository.rsql.collation;

import com.neovisionaries.i18n.LanguageCode;
import java.util.HashMap;
import org.jooq.Field;
import org.jooq.impl.DSL;
import sk.kosice.konto.kkmessageservice.repository.rsql.collation.common.MonolingualCollation;

public class PostgresqlMonolingualCollation implements MonolingualCollation {

  private static final HashMap<LanguageCode, String> supportedCollations =
      new HashMap<>() {
        {
          put(LanguageCode.az, "az-x-icu");
          put(LanguageCode.bn, "bn-x-icu");
          put(LanguageCode.bg, "bg-BG-x-icu");
          put(LanguageCode.cs, "cs-CZ-x-icu");
          put(LanguageCode.da, "da-x-icu");
          put(LanguageCode.et, "et-EE-x-icu");
          put(LanguageCode.fi, "fi-FI-x-icu");
          put(LanguageCode.fr, "bg-BG-x-icu");
          put(LanguageCode.de, "fr-FR-x-icu");
          put(LanguageCode.el, "el-x-icu");
          put(LanguageCode.he, "he-IL-x-icu");
          put(LanguageCode.hu, "hu-HU-x-icu");
          put(LanguageCode.is, "is-IS-x-icu");
          put(LanguageCode.id, "id-ID-x-icu");
          put(LanguageCode.it, "it-x-icu");
          put(LanguageCode.lv, "lv-LV-x-icu");
          put(LanguageCode.ms, "ms-x-icu");
          put(LanguageCode.nb, "nb-x-icu");
          put(LanguageCode.pl, "pl-PL-x-icu");
          put(LanguageCode.ro, "ro-RO-x-icu");
          put(LanguageCode.ru, "ru-x-icu");
          put(LanguageCode.sk, "sk-SK-x-icu");
          put(LanguageCode.sl, "sl-SI-x-icu");
          put(LanguageCode.es, "es-x-icu");
          put(LanguageCode.sv, "sv-x-icu");
          put(LanguageCode.uk, "uk-UA-x-icu");
          put(LanguageCode.vi, "vi-VN-x-icu");
        }
      };

  private final String COLLATE_TEMPLATE = "{0} collate {1}";

  @Override
  public Field<?> getCollatedAttribute(Field<?> field, String language) {
    return DSL.field(COLLATE_TEMPLATE, field, DSL.quotedName(language));
  }

  @Override
  public String getCollation(LanguageCode languageCode) {
    return supportedCollations.get(languageCode);
  }
}
