package sk.kosice.konto.kkmessageservice.repository.rsql.converter;

import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlErrorCode;

public class EnumValueConverter<E extends Enum<E>> implements FieldValueConverter<E> {

  private final Class<E> enumClass;

  public EnumValueConverter(Class<E> enumClass) {
    this.enumClass = enumClass;
  }

  @Override
  public boolean isAccessibleFor(Class clazz) {
    return enumClass.isAssignableFrom(clazz);
  }

  @Override
  public E from(String from) {
    try {
      return Enum.valueOf(enumClass, from);
    } catch (IllegalArgumentException e) {
      throw RsqlErrorCode.INVALID_RSQL_VALUE_EXCEPTION.createError(from).convertToException();
    }
  }

  public static <T extends Enum<T>> EnumValueConverter<T> of(Class<T> enumClass) {
    return new EnumValueConverter<>(enumClass);
  }
}
