package sk.kosice.konto.kkmessageservice.restapi.config.security;

import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;

public final class CombinedDoubleJwtDecoder implements JwtDecoder {

  private final JwtDecoder firstDecoder;
  private final JwtDecoder secondDecoder;

  public CombinedDoubleJwtDecoder(JwtDecoder firstDecoder, JwtDecoder secondDecoder) {
    this.firstDecoder = firstDecoder;
    this.secondDecoder = secondDecoder;
  }

  @Override
  public Jwt decode(String token) throws JwtException {
    try {
      return firstDecoder.decode(token);
    } catch (JwtException e) {
      return secondDecoder.decode(token);
    }
  }
}
