package sk.kosice.konto.kkmessageservice.config.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import sk.kosice.konto.kkmessageservice.config.error.BusinessConfigErrorCode;
import sk.kosice.konto.kkmessageservice.domain.businessconfig.BusinessConfig;
import sk.kosice.konto.kkmessageservice.domain.businessconfig.ImmutableBusinessConfig;

@Configuration(proxyBeanMethods = false)
public class SpringBusinessProperties {
  @Value("${sk.kosice.message.check-permissions.admin-role-id}")
  public String adminRoleId;

  @Value("${sk.kosice.message.check-permissions.admin-global-role-id}")
  public String adminGlobalRoleId;

  private static final Logger log = LoggerFactory.getLogger(SpringBusinessProperties.class);

  public BusinessConfig buildBusinessConfig() {
    if (adminRoleId == null) {
      log.error("sk.kosice.message.check-permissions.admin-role-id is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_ADMIN_ROLE_ID.createError().convertToException();
    }

    if (adminGlobalRoleId == null) {
      log.error(
          "sk.kosice.message.check-permissions.admin-global-role-id is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_ADMIN_GLOBAL_ROLE_ID
          .createError()
          .convertToException();
    }

    return ImmutableBusinessConfig.builder()
        .adminRoleId(adminRoleId)
        .adminGlobalRoleId(adminGlobalRoleId)
        .build();
  }

  public String getAdminRoleId() {
    return adminRoleId;
  }

  public void setAdminRoleId(String adminRoleId) {
    this.adminRoleId = adminRoleId;
  }

  public String getAdminGlobalRoleId() {
    return adminGlobalRoleId;
  }

  public void setAdminGlobalRoleId(String adminGlobalRoleId) {
    this.adminGlobalRoleId = adminGlobalRoleId;
  }
}
