package sk.kosice.konto.kkmessageservice.domain.recipient.error;

import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.NOT_FOUND;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum RecipientErrorCode implements ErrorCode {
  RECIPIENT_DOES_NOT_EXIST(NOT_FOUND, "Recipient with kid '%s' does not exist.");

  private final ErrorCodeType type;
  private final String template;

  RecipientErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
