import React from 'react';

interface TableListProps {
  children: React.ReactNode;
}

interface TableListItemsProps {
  children: React.ReactNode;
}

interface TableListValueProps {
  label: string;
  children: React.ReactNode;
}

interface TableListActionProps {
  children: React.ReactNode;
}

export const TableListAction: React.FC<TableListActionProps> = ({ children }) => (
  <div className="flex items-center justify-center">{children}</div>
);

export const TableListValue: React.FC<TableListValueProps> = ({ label, children }) => (
  <li className="flex justify-between gap-4 px-3 py-4 idsk-text-body">
    <span>{label}</span>
    <span className="text-right">{children}</span>
  </li>
);

export const TableListItem: React.FC<TableListItemsProps> = ({ children }) => (
  <li className="bg-neutral-90 border border-neutral-300 rounded-md">
    <ul className="divide-y divide-neutral-300">{children}</ul>
  </li>
);

const TableList: React.FC<TableListProps> = ({ children }) => <ul className="flex flex-col gap-5">{children}</ul>;

export default TableList;
