import React from 'react';
import MessageListPlaceholder from './MessageListPlaceholder';

const MessageListLoading: React.FC<{ pageSize: number }> = ({ pageSize }) => (
  <MessageListPlaceholder>
    {Array.from({ length: pageSize }).map((_, index) => (
      <div
        key={index}
        className="px-7 py-5 bg-white last:rounded-b-lg border-t border-neutral-300 flex tb2:gap-8 gap-2.5 tb2:flex-row flex-col"
      >
        <div className="animate-pulse bg-neutral-300 tb2:w-[14rem] dm1:w-[18rem] mr-6 h-4 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 w-[60%] h-4 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 w-32 h-4 my-2.5 rounded tb2:ml-auto" />
      </div>
    ))}
  </MessageListPlaceholder>
);

export default MessageListLoading;
