'use client';

import React from 'react';
import { useTranslations } from 'next-intl';
import { FooterContainer, Logo } from '@/lib/idsk';
import { useEnvironment } from '@/context';
import LogoKosice from '@/assets/logo_kosice_labeled.svg';
import { Version } from '../core';
import Link from 'next/link';

const Footer: React.FC = () => {
  const { link, config } = useEnvironment();
  const t = useTranslations('footer');

  return (
    <FooterContainer
      className="relative"
      logo={
        <div className="flex tb2:flex-row flex-col justify-between w-full gap-4">
          <p>
            {t.rich('createdInCompliance', {
              link: (children) => (
                <a href={link.idsk} className="!no-underline" target="_blank" rel="noreferrer">
                  {children}
                </a>
              )
            })}
          </p>
          <Logo className="tb2:ml-auto" image={<LogoKosice />} />
        </div>
      }
      linksList={[
        <a key="0" href={link.privacyPolicy} target="_blank" rel="noreferrer">
          {t('privacy_policy')}
        </a>,
        <a key="1" href={link.accessibilityStatement} target="_blank" rel="noreferrer">
          {t('accessibility_statement')}
        </a>,
        <Link key="2" href={'/cookies'} rel="noreferrer">
          {t('cookieSettings')}
        </Link>
      ]}
      bottomSection={
        <>
          <p>
            {t('serviceOperator')} <Version />
          </p>
          <p>{t('userSupport', { phone: config.phone || '-', email: config.email || '-' })}</p>
        </>
      }
    />
  );
};

export default Footer;
