// @ts-ignore
'use client';

import { Navigation, NavigationLink } from '@/lib/idsk';
import { cn, IUser, PermissionType } from '@/utils';
import { usePathname } from 'next/navigation';
import Link from 'next/link';

const MobileNavigation: React.FC<{ toggleOpen: () => void; user?: IUser }> = ({ user, toggleOpen }) => {
  const pathname = usePathname();
  const permissions = (user?.permissions || []) as PermissionType[];

  const isActive = (href: string) => {
    return pathname.includes(href);
  };

  const linkClasses = (href: string) => {
    return cn({ 'font-bold !text-primary-medium': isActive(href) });
  };

  return (
    <Navigation label="Menu" className="my-5">
      <>
        {permissions.includes('ACTION_MANAGE_MESSAGE') ? (
          <NavigationLink
            linkElement={
              <Link href="/spravy" className={linkClasses('/spravy')} onClick={toggleOpen}>
                Správy
              </Link>
            }
          />
        ) : null}

        {permissions.includes('ACTION_MANAGE_TOPIC') ? (
          <NavigationLink
            linkElement={
              <Link href="/temy" className={linkClasses('/temy')} onClick={toggleOpen}>
                Témy
              </Link>
            }
          />
        ) : null}
      </>
    </Navigation>
  );
};

export default MobileNavigation;
