package sk.kosice.konto.kknotificationservice.mailjet.sendemail;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_BAD_REQEUEST;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_FORBIDDEN;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_INTERNAL_ERROR;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_UNAUTHORIZED;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.errors.MailjetException;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessException;
import sk.kosice.konto.kknotificationservice.mailjet.MailjetClientAdapterTest;

public class MailjetClientAdapterSendTest extends MailjetClientAdapterTest
    implements MailjetClientAdapterSendTestSupport {

  @Test
  public void thatEmailCanBeMappedAndSent() throws MailjetException {
    final var command = createSendEmailCommand();

    emailSenderPort.sendEmail(command);
    verify(mailjetClient, times(1)).post(any(MailjetRequest.class));
  }

  @Test
  public void thatEmailSend400ErrorCanBeHandled() throws MailjetException {
    prepareClient400Response();

    final var ex =
        assertThrows(
            BusinessException.class, () -> emailSenderPort.sendEmail(createSendEmailCommand()));
    assertThat(ex.getError().code()).isEqualTo(MAILJET_CLIENT_BAD_REQEUEST);
  }

  @Test
  public void thatEmailSend401ErrorCanBeHandled() throws MailjetException {
    prepareClient401Response();

    final var ex =
        assertThrows(
            BusinessException.class, () -> emailSenderPort.sendEmail(createSendEmailCommand()));
    assertThat(ex.getError().code()).isEqualTo(MAILJET_CLIENT_UNAUTHORIZED);
  }

  @Test
  public void thatEmailSend403ErrorCanBeHandled() throws MailjetException {
    prepareClient403Response();

    final var ex =
        assertThrows(
            BusinessException.class, () -> emailSenderPort.sendEmail(createSendEmailCommand()));
    assertThat(ex.getError().code()).isEqualTo(MAILJET_CLIENT_FORBIDDEN);
  }

  @Test
  public void thatEmailSend500ErrorCanBeHandled() throws MailjetException {
    prepareClient500Response();

    final var ex =
        assertThrows(
            BusinessException.class, () -> emailSenderPort.sendEmail(createSendEmailCommand()));
    assertThat(ex.getError().code()).isEqualTo(MAILJET_CLIENT_INTERNAL_ERROR);
  }
}
