package sk.kosice.konto.kknotificationservice.repository.message;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

import org.junit.jupiter.api.Test;

public class JooqMessageRepositoryMarkTest extends JooqMessageRepositoryTest {

  @Test
  public void thatMessageCanBeMarkedAsSent() {
    insertMessages(dslContext);

    final var messages = findMessagesWasNotSent(messageRepository);
    assertThat(messages).isNotNull();
    assertThat(messages.size()).isEqualTo(2);

    markMessageAsSent(messageRepository, messages.getFirst().id());
    markMessageAsSent(messageRepository, messages.getLast().id());

    final var updatedMessages = findMessagesWasNotSent(messageRepository);
    assertThat(updatedMessages).isNotNull();
    assertThat(updatedMessages.size()).isZero();
  }
}
