package sk.kosice.konto.kknotificationservice.repository.recipient;

import java.util.UUID;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.ImmutableRecipientEntity;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.RecipientEntity;

public interface JooqRecipientRepositoryTestSupport {

  default ImmutableRecipientEntity prepareRecipientData() {
    return ImmutableRecipientEntity.builder()
        .kid(UUID.randomUUID())
        .email("ferko@kosice.sk")
        .build();
  }

  default void mergeRecipient(JooqRecipientRepository repository, RecipientEntity insertData) {
    repository.merge(insertData);
  }

  default RecipientEntity findRecipient(JooqRecipientRepository repository, UUID kid) {
    return repository.findOne(kid);
  }

  default RecipientEntity mergeAndFindRecipient(
      JooqRecipientRepository repository, RecipientEntity insertData) {
    mergeRecipient(repository, insertData);
    return findRecipient(repository, insertData.kid());
  }
}
