package sk.kosice.konto.kknotificationservice.business.message.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kknotificationservice.business.AbstractService;
import sk.kosice.konto.kknotificationservice.business.message.port.inbound.MarkMessageAsSentUseCase;
import sk.kosice.konto.kknotificationservice.business.message.port.outbound.PersistMessagePort;
import sk.kosice.konto.kknotificationservice.domain.message.command.MarkMessageAsSentCommand;

@Named
public class MarkMessageAsSentService extends AbstractService implements MarkMessageAsSentUseCase {

  private final PersistMessagePort persistMessagePort;

  @Inject
  public MarkMessageAsSentService(PersistMessagePort persistMessagePort) {
    this.persistMessagePort = persistMessagePort;
  }

  @Override
  public void execute(MarkMessageAsSentCommand command) {
    persistMessagePort.markMessageAsSent(command.messageId());
  }
}
