package sk.kosice.konto.kknotificationservice.mailjet.sendemail;

import java.util.List;
import sk.kosice.konto.kknotificationservice.domain.email.command.ImmutableSendEmailCommand;
import sk.kosice.konto.kknotificationservice.domain.email.command.SendEmailCommand;
import sk.kosice.konto.kknotificationservice.domain.email.entity.ImmutableSenderInfo;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.EmailBodyType;

public interface MailjetClientAdapterSendTestSupport {

  default SendEmailCommand createSendEmailCommand() {
    return ImmutableSendEmailCommand.builder()
        .messageTitle("testTitle")
        .messageBody("testBody")
        .messageBodyType(EmailBodyType.TEXT)
        .senderInfo(
            ImmutableSenderInfo.builder().email("testEmail@test.com").name("testName").build())
        .addAllRecipients(List.of("testRecipient@test.com"))
        .build();
  }
}
