package sk.kosice.konto.kknotificationservice.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import sk.kosice.konto.kknotificationservice.mailjet.configuration.properties.MailjetClientPropertiesPort;

@Validated
@Configuration(proxyBeanMethods = false)
@ConfigurationProperties(prefix = "sk.kosice.notification.mailjet.security.credentials")
public class MailjetClientPropertiesAdapter implements MailjetClientPropertiesPort {

  private String apiKey;
  private String secretKey;

  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }

  public void setSecretKey(String secretKey) {
    this.secretKey = secretKey;
  }

  @Override
  public String apiKey() {
    return apiKey;
  }

  @Override
  public String secretKey() {
    return secretKey;
  }
}
