import React from 'react';
import MessageListPlaceholder from './MessageListPlaceholder';

const MessageListLoading: React.FC<{ pageSize: number }> = ({ pageSize }) => (
  <MessageListPlaceholder>
    {Array.from({ length: pageSize }).map((_, index) => (
      <div
        key={index}
        className="px-7 py-3 bg-white last:rounded-b-lg border-t border-neutral-300 grid grid-cols-1 tb2:grid-cols-12 gap-2 tb2:gap-4"
      >
        <div className="animate-pulse bg-neutral-300 col-span-3 w-full h-6 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 col-span-3 w-full h-6 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 col-span-2 w-4/6 tb2:w-full h-6 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 col-span-4 w-[6rem] h-6 my-2.5 tb2:ml-auto rounded" />
      </div>
    ))}
  </MessageListPlaceholder>
);

export default MessageListLoading;
