package sk.kosice.konto.kkmessageservice.business.organization.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.organization.port.inbound.FindSubscribedOrganizationsByRecipientUseCase;
import sk.kosice.konto.kkmessageservice.business.organization.port.outbound.QueryOrganizationPort;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.QuerySubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.FindSubscribedOrganizationsByKidQuery;

@Named
public class FindSubscribedOrganizationsByRecipientService extends AbstractService
    implements FindSubscribedOrganizationsByRecipientUseCase {

  private final QuerySubscriptionPort querySubscriptionPort;
  private final QueryOrganizationPort queryOrganizationPort;

  @Inject
  public FindSubscribedOrganizationsByRecipientService(
      QuerySubscriptionPort querySubscriptionPort, QueryOrganizationPort queryOrganizationPort) {
    this.querySubscriptionPort = querySubscriptionPort;
    this.queryOrganizationPort = queryOrganizationPort;
  }

  @Override
  public List<OrganizationEntity> execute(FindSubscribedOrganizationsByKidQuery query) {
    final var subscriptions = querySubscriptionPort.listUniqueForKid(query);

    return subscriptions.stream()
        .map(subscription -> queryOrganizationPort.findOne(subscription.organization().id()))
        .toList();
  }
}
