/**
 * API class.
 */

import App from "mihbbtv/lib/hbbtv/application";
import Request from "mihbbtv/lib/hbbtv/request";

const API_DOMAIN = 'http://hbbtv.croapi.cz';
const ENDPOINTS = {
  // main: 'http://harvester.mihybrid.com/tv/apps/5ef0bec07424ad002070432c/config?scene=',
  mock: 'http://mihybrid.com/hbb/hbb-cro-mujrozhlas/mocks/',
  home: API_DOMAIN + '/hbbtv/home',
  subjects: API_DOMAIN + '/hbbtv/topics',
  gamesandreadings: API_DOMAIN + '/hbbtv/topics/671d0806-2afe-4282-ae90-319b6ef369a2',
  kids: API_DOMAIN + '/hbbtv/topics/8ed08518-9d92-437c-a96f-e5df046aff4e',
  documents: API_DOMAIN + '/hbbtv/topics/05bc9bd7-7a9d-49a6-b1aa-12a7bfb558f7',
  topic: API_DOMAIN + '/hbbtv/topics/',
  detail: API_DOMAIN + '/hbbtv/detail/',
  shows: API_DOMAIN + '/hbbtv/shows',
  show: API_DOMAIN + '/hbbtv/show/',
  podcasts: API_DOMAIN + '/hbbtv/podcasts',
  live: API_DOMAIN + '/hbbtv/live',
  search: API_DOMAIN + '/hbbtv/search',
  login: API_DOMAIN + '/hbbtv/login',
};

class Api {

  static mainItem(name, params, cb, err) {
    // console.log(params);

    params.push({
      name: 'scene',
      value: name,
    });

    let url = ENDPOINTS.mock + name + 'MockData.json';

    if (ENDPOINTS[name]) {
      url = ENDPOINTS[name];
    } else {
      params.push({
        name: '_t',
        value: (new Date()).getTime(),
      });
    }

    const paramsQuery = params.map((item) => (item.value ? item.name + '=' + item.value : null)).filter((item) => !!item).join('&');
    const junction = url.match(/\?/) ? '&' : '?';

    Request.get(url + (paramsQuery ? junction + paramsQuery : ''), null, (data) => {
      const parsed = Request.response(data);

      return cb(parsed);
    }, () => {
      return Api.err(cb, err);
    });
  }

  static login(params, cb, err) {
    // console.log(params);

    const url = ENDPOINTS.login;
    
    const paramsQuery = params.map((item) => (item.value ? item.name + '=' + item.value : null)).filter((item) => !!item).join('&');
    const junction = url.match(/\?/) ? '&' : '?';

    Request.get(url + (paramsQuery ? junction + paramsQuery : ''), null, (data) => {
      const parsed = Request.response(data);

      const response = {
        config: {
          order: [{
            name: "login",
            heading: "Přihlásit se",
            component: "login"
          }]
        },
        login: {
          // sessionId: "asfgsdgh45hdfjhdj54jdgjere",
          loginSessionCode: parsed.loginSessionCode,
          qrShow: true,
          qrImg: parsed.qrImg,
          statusUrl: parsed.statusUrl,
          loginUrl: parsed.loginUrl,
        }
      };

      return cb(response);
    }, () => {
      return Api.err(cb, err);
    });
  }

  static detail(type, params, cb, err) {
    // console.log(type, params);

    let url = ENDPOINTS[type] + params[0].value;

    const paramsQuery = params.map((item) => (item.value ? item.name + '=' + item.value : null)).filter((item) => !!item).join('&');
    const junction = url.match(/\?/) ? '&' : '?';

    Request.get(url + (paramsQuery ? junction + paramsQuery : ''), null, (data) => {
      const parsed = Request.response(data);

      return cb(parsed);
    }, () => {
      return Api.err(cb, err);
    });
  }

  static direct(url, cb, err) {
    if (! url.match(/http:\/\//i)) {
      url = API_DOMAIN + url;
    }

    Request.get(url, null, (data) => {
      const parsed = Request.response(data);

      return cb(parsed);
    }, () => {
      return Api.err(cb, err);
    });
  }

  static loginStatus(url, cb) {
    Request.get(url, null, (data) => {
      const parsed = Request.response(data);

      parsed.status = true;
      
      return cb(parsed);
    }, () => {
      return cb({
        status: false,
      });
    });
  }

  static err(cb, err) {
    if (err) {
      err();
    }

    const activeScene = App.getActiveScene();

    if ('error' !== activeScene.handle) {
      App.setScene('error', null, {error: {
        heading: 'Chyba připojení',
        msg: 'Spojení se serverem bylo přerušeno. Zkuste prosím načíst aplikaci později.'
      }});
    }
  }
}

export default Api;
