export const config = {
  ga: null,
  gaTag: 'G-D2WYMEN3K0',
  history: {
    size: 5,
    isPersistent: true,
    storagePrefix: '_hybahstrBoiler_',
  },
  remoteReportUrl: 'http://harvester.mihybrid.com/tv/apps/5f44d8fa0391ea002404cc30/collect',
  scenes: [
    {name: 'home', class: null},
    {name: 'shows', class: null},
    {name: 'live', class: null},
    {name: 'podcasts', class: null},
    {name: 'subjects', class: null},
    {name: 'search', class: null},
    {name: 'gamesandreadings', class: null},
    {name: 'documents', class: null},
    {name: 'kids', class: null},
    {name: 'login', class: null},
    {name: 'logout', class: null},
    {name: 'profile', class: null},
    {name: 'detail', class: 'detail'},
  ],
  init: {
    act: 1,
    componentIndex: 0
  },
  menu: {
    axis: 'y',
    confirmEnter: true,
    items: [
      {handle: 'home', title: 'Přehled', class: 'logo', icon: true, act: 1},
      {class: 'spacer'},
      {handle: 'shows', title: 'Pořady', class: 'shows', icon: true, act: 1},
      {handle: 'live', title: 'Živé vysílání', class: 'live', icon: true, act: 1},
      // {handle: 'podcasts', title: 'Podcasty', class: 'podcasts', icon: true, act: 1},
      {handle: 'subjects', title: 'Témata', class: 'subjects', icon: true, act: 1},
      {handle: 'search', title: 'Vyhledávání', class: 'search', icon: true, act: 1},
      {class: 'spacer'},
      {handle: 'gamesandreadings', title: 'Hry a četba', class: 'gamesandreadings', icon: true, act: 1},
      {handle: 'documents', title: 'Dokumenty', class: 'documents', icon: true, act: 1},
      {handle: 'kids', title: 'Pro děti', class: 'kids', icon: true, act: 1},
      {class: 'spacer'},
      {handle: 'login', title: 'Přihlásit se', class: 'login', icon: true, act: 1},
    ],
  },
  resizer: {
    enabled: false
  },
  preloadImages: {
    enabled: false
  },
  ui: {
    carousel: {
      viewWidth: 1002,
    },
    list: {
      default: {
        viewHeight: 320,
        itemHeight: 160,
      },
    },
    grid: {
      default: {
        perLine: 3,
        viewHeight: 250,
        lineHeight: 250,
        offAxis: 50
      },
      rectangleL: {
        perLine: 3,
        viewHeight: 200,
        lineHeight: 200,
        offAxis: 50
      },
      rectangleM: {
        perLine: 4,
        viewHeight: 160,
        lineHeight: 160,
        offAxis: 50
      },
      rectangleS: {
        perLine: 5,
        viewHeight: 145,
        lineHeight: 145,
        offAxis: 50
      },
        squareL: {
        perLine: 6,
        viewHeight: 164,
        lineHeight: 164,
        offAxis: 50
      },
    },
    item: {
      default: {
        w: 300,
        h: 200,
      },
      rectangleL: {
        w: 300,
        h: 200,
      },
      rectangleM: {
        w: 230,
        h: 130,
      },
      rectangleS: {
        w: 180 + 8 + 10,
        h: 101 + 8,
      },
      squareL: {
        w: 158 + 5 + 8,
        h: 158 + 10 + 8,
      },
      squareM: {
        w: 120 + 10 + 8,
        h: 120 + 8,
      },
    },
  }
};

export default config;
