/**
 * Item model.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 *
 */

'use strict';

import Config from "../config";
import Image from "mihbbtv/lib/components/image";
import Resizer from "mihbbtv/lib/util/resizer";
import FloatingPlayer from "../components/floatingPlayer";
import Sanitize from "mihbbtv/lib/util/sanitize";

class Item {

  static limitTitle(val, max = 72) {
    return Sanitize.html(val, max);
  }

  static itemMarkup(item) {

    const isLive = ('live' === item.type);
    item.progress = parseInt(item.progress);
    item.progress = (item.progress >= 0 && item.progress <= 100) ? item.progress : 1;

    const img = (item.img) ? item.img : null;

    return ((isLive && item.logo) ? '<img class="logo" src="' + item.logo + '" />' : '') +
    Image.markup({
      src: (Config.resizer && Config.resizer.enabled) ? Resizer.url(img, 280, 160) : img,
      rounded: {
        tl: true,
        tr: true,
        bl: true,
        br: true,
      },
      class: (img) ? '' : 'empty',
    }) +
    '<div class="title">' +
      Item.limitTitle(item.title) +
    '</div>' +
    ((isLive && item.progress >= 0) ? (
      '<div class="progress"><div class="progressBar" style="width:' + item.progress + '%;"></div></div>'
    ) : '') +
    ((isLive && item.next) ? '<div class="next"><span class="time">' + item.next.time + '</span><span class="title">' + item.next.title + '</span></div>' : '')
    ;
  }

  static enterItem(item, app, scene, elm = null) {
    if (! item) {
      return false;
    }

    // console.log(item);

    if ('audio' === item.type || 'live' === item.type) {

      // seng GA event
      app.gaSendEvent(item.type, 'play', item.headline);

      return FloatingPlayer.getInstance().play(item, elm);

    } else {
      // seng GA event
      app.gaSendEvent(item.type || 'component', 'enter', item.title);

      return app.setScene('detail', null, {detail: {
        id: item.id,
        type: item.type,
      }});
    }
  }

  static filterItem(item, app, scene, elm = null) {
    if (! item) {
      return false;
    }

    // console.log(item);

    return app.setScene(scene.handle, scene.activeAct, {filter: item});

  }
}

export default Item;
