package sk.kosice.konto.kkmessageservice.repository.rsql.collation.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum MonolingualCollationErrorCode implements ErrorCode {
  DB_UNSUPPORTED_DIALECT(
      ErrorCodeType.INTERNAL, "Dialect '%s' is not supported for attributes translation.");

  final String template;
  final ErrorCodeType type;

  MonolingualCollationErrorCode(ErrorCodeType type, String template) {
    this.template = template;
    this.type = type;
  }

  @Override
  public String template() {
    return template;
  }

  @Override
  public ErrorCodeType type() {
    return type;
  }
}
