package sk.kosice.konto.kkmessageservice.repository.rsql.converter;

import java.util.Objects;
import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlErrorCode;

public class BooleanValueConverter implements FieldValueConverter<Boolean> {

  @Override
  public boolean isAccessibleFor(Class clazz) {
    return Boolean.class.isAssignableFrom(clazz);
  }

  @Override
  public Boolean from(String from) {

    if (Objects.nonNull(from)
        && (from.equalsIgnoreCase(Boolean.TRUE.toString())
            || from.equalsIgnoreCase(Boolean.FALSE.toString()))) {
      return Boolean.valueOf(from);
    }
    throw RsqlErrorCode.INVALID_RSQL_BOOLEAN_VALUE_EXCEPTION.createError(from).convertToException();
  }
}
