package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.builder;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.List;
import org.jooq.SelectQuery;
import org.jooq.impl.QOM;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.domain.Join;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadata;

public class JooqRsqlSelectBuilder extends JooqRsqlWithListingMetadataBuilder<SelectQuery> {

  private SelectQuery query;
  private JooqRsqlConditionBuilder jooqRsqlConditionBuilder;
  private JooqRsqlJoinBuilder jooqRsqlJoinBuilder;
  private String AGGREGATE_FUNCTION_CLASS_NAME = "AbstractAggregateFunction";

  public JooqRsqlSelectBuilder(SelectQuery query) {
    this.query = query;
    this.jooqRsqlConditionBuilder = new JooqRsqlConditionBuilder();
    this.jooqRsqlJoinBuilder = new JooqRsqlJoinBuilder();
  }

  @Override
  public SelectQuery build(LogicalNode node) {
    build(query, node);
    return query;
  }

  @Override
  public SelectQuery build(ComparisonNode node) {
    build(query, node);
    return query;
  }

  private void build(SelectQuery query, Node node) {
    addJoin(query, node);
    if (nodeIsAggregateFunction(query, node)) {
      addHavingCondition(query, node);
    } else {
      addWhereCondition(query, node);
    }
  }

  private void addJoin(SelectQuery query, Node node) {
    final List<Join> joins = jooqRsqlJoinBuilder.build(node);

    for (Join join : joins) {
      query.addJoin(join.table(), join.type(), join.condition());
    }
  }

  private void addWhereCondition(SelectQuery query, Node node) {
    query.addConditions(jooqRsqlConditionBuilder.build(node));
  }

  private void addHavingCondition(SelectQuery query, Node node) {
    query.addHaving(jooqRsqlConditionBuilder.build(node));
  }

  @Override
  public void setJooqRsqlMetadata(JooqRsqlMetadata metadata) {
    super.setJooqRsqlMetadata(metadata);
    this.jooqRsqlConditionBuilder.setJooqRsqlMetadata(metadata);
    this.jooqRsqlJoinBuilder.setJooqRsqlMetadata(metadata);
  }

  private boolean nodeIsAggregateFunction(SelectQuery query, Node node) {
    Object selectField = getSelectField(query, node);

    try {
      if (selectField instanceof QOM.FieldAlias<?> aliasField) {
        return AGGREGATE_FUNCTION_CLASS_NAME.equals(
            aliasField
                .$aliased() // we uncover what alias wraps
                .getClass()
                .getSuperclass()
                .getSimpleName());
      } else {
        return AGGREGATE_FUNCTION_CLASS_NAME.equals(
            selectField.getClass().getSuperclass().getSimpleName());
      }
    } catch (Exception e) {
      return false;
    }
  }

  private Object getSelectField(SelectQuery query, Node node) {
    if (node instanceof ComparisonNode comparisonNode) {
      int indexOfNodeInSelectFieldList = query.indexOf(comparisonNode.getSelector());
      if (indexOfNodeInSelectFieldList >= 0) {
        return query.getSelect().get(indexOfNodeInSelectFieldList);
      }
    }
    return null;
  }
}
