package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum JooqOrderingHandlerErrorCode implements ErrorCode {
  LANGUAGE_CODE_NOT_PRESENT(
      ErrorCodeType.BAD_REQUEST, "Attribute '%s' is translated but no language was present.");

  final String template;
  final ErrorCodeType type;

  JooqOrderingHandlerErrorCode(ErrorCodeType type, String template) {
    this.template = template;
    this.type = type;
  }

  @Override
  public String template() {
    return template;
  }

  @Override
  public ErrorCodeType type() {
    return type;
  }
}
