package sk.kosice.konto.kkmessageservice.repository.subscription.mapper;

import java.util.stream.Stream;
import org.jooq.Record;
import org.jooq.RecordMapper;
import sk.kosice.konto.kkmessageservice.domain.common.TriFunction;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseOrganization;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseTopic;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableListOfSubscriptions;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ListOfSubscriptions;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.SubscriptionListingQuery;
import sk.kosice.konto.kkmessageservice.repository.model.tables.records.SubscriptionRecord;
import sk.kosice.konto.kkmessageservice.repository.model.tables.records.TopicRecord;

public final class JooqSubscriptionRepositoryMapper {

  public static RecordMapper<Record, SubscriptionEntity> subscriptionRecordMapper() {
    return record -> {
      final var subscriptionRecord = record.into(SubscriptionRecord.class);
      final var topicRecord = record.into(TopicRecord.class);

      return ImmutableSubscriptionEntity.builder()
          .id(subscriptionRecord.getId())
          .isEmailEnabled(subscriptionRecord.getIsEmailEnabled())
          .recipientKid(subscriptionRecord.getRecipientKid())
          .topic(
              new BaseTopic(
                  topicRecord.getId(), topicRecord.getName(), topicRecord.getDescription()))
          .organization(
              new BaseOrganization(
                  topicRecord.getOrganizationId(), topicRecord.getOrganizationName()))
          .build();
    };
  }

  public static final TriFunction<
          Stream<Record>, Integer, SubscriptionListingQuery, ListOfSubscriptions>
      listingMapper =
          (records, totalCount, query) ->
              ImmutableListOfSubscriptions.builder()
                  .page(query.page())
                  .pageSize(query.pageSize().value())
                  .totalCount(totalCount)
                  .addAllItems(
                      records.map(record -> subscriptionRecordMapper().map(record)).toList())
                  .build();
}
