package sk.kosice.konto.kkmessageservice.restapi.mapper;

import java.util.stream.Collectors;
import sk.kosice.konto.kkmessageservice.domain.message.entity.BaseMessageEntity;
import sk.kosice.konto.kkmessageservice.domain.message.entity.ListOfMessages;
import sk.kosice.konto.kkmessageservice.domain.message.entity.MessageEntity;
import sk.kosice.konto.kkmessageservice.restapi.common.ObjectMapperHelper;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableBaseMessageDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableBaseMessageWithKidDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageTopicDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageWithKidDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.ImmutableMessageWithKidListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.MessageListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.message.MessageWithKidListResponse;

public final class MessageResponseMapper {

  public static ImmutableBaseMessageDto map(BaseMessageEntity entity) {
    return ImmutableBaseMessageDto.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .topic(
            ImmutableMessageTopicDto.builder()
                .id(entity.topicId())
                .name(entity.topicName())
                .build())
        .createdAt(entity.createdAt())
        .senderId(entity.organizationId())
        .tags(entity.tags().map(ObjectMapperHelper::createJsonNodeListFromString))
        .build();
  }

  public static ImmutableBaseMessageWithKidDto mapWithKid(BaseMessageEntity entity) {
    return ImmutableBaseMessageWithKidDto.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .topic(
            ImmutableMessageTopicDto.builder()
                .id(entity.topicId())
                .name(entity.topicName())
                .build())
        .createdAt(entity.createdAt())
        .senderId(entity.organizationId())
        .tags(entity.tags().map(ObjectMapperHelper::createJsonNodeListFromString))
        .recipientKid(entity.recipientKid())
        .build();
  }

  public static ImmutableMessageDetailResponse map(MessageEntity entity) {
    return ImmutableMessageDetailResponse.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .topic(
            ImmutableMessageTopicDto.builder()
                .id(entity.topicId())
                .name(entity.topicName())
                .build())
        .createdAt(entity.createdAt())
        .senderId(entity.organizationId())
        .bodyType(entity.bodyType())
        .body(entity.body())
        .bodyShort(entity.bodyShort())
        .actions(entity.actions().map(ObjectMapperHelper::createJsonNodeListFromString))
        .tags(entity.tags().map(ObjectMapperHelper::createJsonNodeListFromString))
        .addAllLocations(entity.locations())
        .build();
  }

  public static ImmutableMessageWithKidDetailResponse mapWithKid(MessageEntity entity) {
    return ImmutableMessageWithKidDetailResponse.builder()
        .id(entity.id())
        .senderName(entity.senderName())
        .title(entity.title())
        .topic(
            ImmutableMessageTopicDto.builder()
                .id(entity.topicId())
                .name(entity.topicName())
                .build())
        .createdAt(entity.createdAt())
        .senderId(entity.organizationId())
        .bodyType(entity.bodyType())
        .body(entity.body())
        .bodyShort(entity.bodyShort())
        .actions(entity.actions().map(ObjectMapperHelper::createJsonNodeListFromString))
        .tags(entity.tags().map(ObjectMapperHelper::createJsonNodeListFromString))
        .addAllLocations(entity.locations())
        .recipientKid(entity.recipientKid())
        .build();
  }

  public static MessageListResponse map(ListOfMessages list) {
    return ImmutableMessageListResponse.builder()
        .totalCount(list.totalCount())
        .page(list.page())
        .pageSize(list.pageSize())
        .addAllItems(
            list.items().stream().map(MessageResponseMapper::map).collect(Collectors.toList()))
        .build();
  }

  public static MessageWithKidListResponse mapWithKid(ListOfMessages list) {
    return ImmutableMessageWithKidListResponse.builder()
        .totalCount(list.totalCount())
        .page(list.page())
        .pageSize(list.pageSize())
        .addAllItems(
            list.items().stream()
                .map(MessageResponseMapper::mapWithKid)
                .collect(Collectors.toList()))
        .build();
  }
}
