package sk.kosice.konto.kkmessageservice.config.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import sk.kosice.konto.kkmessageservice.restapi.config.security.OAuthPropertiesPort;

@Validated
@Configuration(proxyBeanMethods = false)
@ConfigurationProperties(prefix = "spring.security.oauth2.resourceserver.jwt")
public class OAuthPropertiesAdapter implements OAuthPropertiesPort {

  private String ocCitizenIssuerLocation;
  private String ocCitizenJwksUrl;
  private String ocEmployeeIssuerLocation;
  private String ocEmployeeJwksUrl;
  private String ocAppIntegrationIssuerLocation;
  private String ocAppIntegrationJwksUrl;

  @Override
  public String ocCitizenIssuerLocation() {
    return ocCitizenIssuerLocation;
  }

  @Override
  public String ocCitizenJwksUrl() {
    return ocCitizenJwksUrl;
  }

  @Override
  public String ocEmployeeIssuerLocation() {
    return ocEmployeeIssuerLocation;
  }

  @Override
  public String ocEmployeeJwksUrl() {
    return ocEmployeeJwksUrl;
  }

  @Override
  public String ocAppIntegrationIssuerLocation() {
    return ocAppIntegrationIssuerLocation;
  }

  @Override
  public String ocAppIntegrationJwksUrl() {
    return ocAppIntegrationJwksUrl;
  }

  public void setOcCitizenIssuerLocation(String ocCitizenIssuerLocation) {
    this.ocCitizenIssuerLocation = ocCitizenIssuerLocation;
  }

  public void setOcCitizenJwksUrl(String ocCitizenJwksUrl) {
    this.ocCitizenJwksUrl = ocCitizenJwksUrl;
  }

  public void setOcEmployeeIssuerLocation(String ocEmployeeIssuerLocation) {
    this.ocEmployeeIssuerLocation = ocEmployeeIssuerLocation;
  }

  public void setOcEmployeeJwksUrl(String ocEmployeeJwksUrl) {
    this.ocEmployeeJwksUrl = ocEmployeeJwksUrl;
  }

  public void setOcAppIntegrationIssuerLocation(String ocAppIntegrationIssuerLocation) {
    this.ocAppIntegrationIssuerLocation = ocAppIntegrationIssuerLocation;
  }

  public void setOcAppIntegrationJwksUrl(String ocAppIntegrationJwksUrl) {
    this.ocAppIntegrationJwksUrl = ocAppIntegrationJwksUrl;
  }
}
