package sk.kosice.konto.kkmessageservice.permission;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.*;

import io.restassured.http.ContentType;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.ServiceAppFeatureSpec;
import sk.kosice.konto.kkmessageservice.restapi.controller.PermissionController;

public class PermissionFeatureSpec extends ServiceAppFeatureSpec {
  protected <T> T listPermissions(UUID userId, HttpStatus status, Class<T> response) {
    return requestSpecification()
        .when()
        .auth()
        .oauth2(EMPLOYEE_JWT_TOKEN)
        .get(PermissionController.PERMISSIONS_BY_USER_ID_URI, userId)
        .then()
        .log()
        .all()
        .statusCode(status.value())
        .contentType(ContentType.JSON)
        .extract()
        .as(response);
  }

  protected <T> T listPermissionsWithoutJwt(UUID userId, HttpStatus status, Class<T> response) {
    return requestSpecification()
        .when()
        .get(PermissionController.PERMISSIONS_BY_USER_ID_URI, userId)
        .then()
        .log()
        .all()
        .statusCode(status.value())
        .contentType(ContentType.JSON)
        .extract()
        .as(response);
  }
}
