package sk.kosice.konto.kkmessageservice.topic;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;
import static sk.kosice.konto.kkmessageservice.domain.permission.error.PermissionErrorCode.ACTION_IS_FORBIDDEN;
import static sk.kosice.konto.kkmessageservice.topic.TopicApiFixtures.createTopicRequest;

import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.restapi.dto.common.error.ErrorDetailResponse;

public class TopicCreateFeatureSpec extends TopicFeatureSpec {

  @Test
  public void thatTopicCanBeCreatedWithEmployeeToken() {
    final var request = createTopicRequest();
    final var response = createTopic(ORGANIZATION_ID_1, request);

    assertThat(response.getName()).isEqualTo(request.getName());
    assertThat(response.getDescription()).isEqualTo(request.getDescription());
  }

  @Test
  public void thatTopicCannotBeCreatedWithoutToken() {
    final var request = createTopicRequest();

    final var errorResponse =
        createTopicWithoutToken(
            ORGANIZATION_ID_1, request, HttpStatus.UNAUTHORIZED, ErrorDetailResponse.class);
    assertThat(errorResponse.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }

  @Test
  public void thatTopicCannotBeCreatedWithEmployeeTokenWithoutPermissions() {
    prepareInvalidPermissions();
    final var request = createTopicRequest();
    final var response =
        createTopic(ORGANIZATION_ID_1, request, HttpStatus.FORBIDDEN, ErrorDetailResponse.class);

    assertThat(response.primaryFault().get().faultCode()).isEqualTo(ACTION_IS_FORBIDDEN.toString());
  }
}
