package sk.kosice.konto.kkmessageservice.topic;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;
import static sk.kosice.konto.kkmessageservice.domain.permission.error.PermissionErrorCode.ACTION_IS_FORBIDDEN;
import static sk.kosice.konto.kkmessageservice.domain.topic.error.TopicErrorCode.TOPIC_DOES_NOT_EXIST;
import static sk.kosice.konto.kkmessageservice.topic.TopicApiFixtures.createTopicRequest;
import static sk.kosice.konto.kkmessageservice.topic.TopicApiFixtures.updateTopicRequest;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.restapi.dto.common.error.ErrorDetailResponse;

public class TopicUpdateFeatureSpec extends TopicFeatureSpec {

  @Test
  public void thatTopicCanBeUpdatedWithEmployeeToken() {
    final var request = createTopicRequest();
    final var response = createTopic(ORGANIZATION_ID_1, request);

    assertThat(response.getName()).isEqualTo(request.getName());
    assertThat(response.getDescription()).isEqualTo(request.getDescription());

    final var updatedRequest = updateTopicRequest();
    final var updatedResponse = updateTopic(ORGANIZATION_ID_1, response.getId(), updatedRequest);
    assertThat(updatedResponse.getId()).isEqualTo(response.getId());
    assertThat(updatedResponse.getOrganizationId()).isEqualTo(response.getOrganizationId());
    assertThat(updatedResponse.getName()).isEqualTo(updatedRequest.getName());
    assertThat(updatedResponse.getDescription()).isEqualTo(updatedRequest.getDescription());
  }

  @Test
  public void thatNotExistingTopicCannotBeUpdated() {
    final var response =
        updateTopic(
            ORGANIZATION_ID_1,
            UUID.randomUUID(),
            updateTopicRequest(),
            HttpStatus.NOT_FOUND,
            ErrorDetailResponse.class);
    assertThat(response.primaryFault().get().faultCode())
        .isEqualTo(TOPIC_DOES_NOT_EXIST.toString());
  }

  @Test
  public void thatTopicCannotBeUpdatedWithoutJwt() {
    final var response =
        updateTopicWithoutJwt(
            UUID.randomUUID(),
            UUID.randomUUID(),
            updateTopicRequest(),
            HttpStatus.UNAUTHORIZED,
            ErrorDetailResponse.class);
    assertThat(response.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }

  @Test
  public void thatTopicCannotBeUpdatedWithEmployeeTokenWithoutPermissions() {
    prepareInvalidPermissions();
    final var request = updateTopicRequest();
    final var response =
        updateTopic(
            ORGANIZATION_ID_1,
            UUID.randomUUID(),
            request,
            HttpStatus.FORBIDDEN,
            ErrorDetailResponse.class);

    assertThat(response.primaryFault().get().faultCode()).isEqualTo(ACTION_IS_FORBIDDEN.toString());
  }
}
