package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.CreateSubscriptionsByOrganizationIdUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.QuerySubscriptionPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ImmutablePageSize;
import sk.kosice.konto.kkmessageservice.domain.common.transactional.Transactional;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.CreateSubscriptionsByOrganizationIdCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.ImmutableSubscriptionListingQuery;

@Named
public class CreateSubscriptionsByOrganizationIdService extends AbstractService
    implements CreateSubscriptionsByOrganizationIdUseCase {

  private final PersistSubscriptionPort persistSubscriptionPort;
  private final QueryTopicPort queryTopicPort;
  private final QuerySubscriptionPort querySubscriptionPort;
  private final Transactional transactional;

  @Inject
  public CreateSubscriptionsByOrganizationIdService(
      PersistSubscriptionPort persistSubscriptionPort,
      QueryTopicPort queryTopicPort,
      QuerySubscriptionPort querySubscriptionPort,
      Transactional transactional) {
    this.persistSubscriptionPort = persistSubscriptionPort;
    this.queryTopicPort = queryTopicPort;
    this.querySubscriptionPort = querySubscriptionPort;
    this.transactional = transactional;
  }

  @Override
  public List<SubscriptionEntity> execute(CreateSubscriptionsByOrganizationIdCommand command) {

    persistSubscriptionPort.insertSubscriptionsByOrganizationIdAndKid(
        command.recipientKid(), command.organizationIds());

    return querySubscriptionPort.listWithoutPaging(
        ImmutableSubscriptionListingQuery.builder()
            .pageSize(ImmutablePageSize.of(100))
            .recipientKid(command.recipientKid())
            .build());
  }
}
