package sk.kosice.konto.kknotificationservice.repository;

import java.util.List;
import java.util.function.Supplier;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessException;
import sk.kosice.konto.kknotificationservice.repository.error.ConstraintErrorCode;
import sk.kosice.konto.kknotificationservice.repository.error.DbErrorCode;
import sk.kosice.konto.kknotificationservice.repository.error.RepositoryErrorHandler;

public abstract class JooqRepository {

  protected final DSLContext dslContext;

  protected static final Logger log = LoggerFactory.getLogger(JooqRepository.class);

  protected JooqRepository(DSLContext dslContext) {
    this.dslContext = dslContext;
  }

  protected static void handleMergeResult(
      Supplier<Integer> supplier, Object dataObject, ConstraintErrorCode... errorCodes)
      throws BusinessException {
    try {
      final Integer numOfMerge = supplier.get();
      if (numOfMerge.equals(0)) {
        dbError("No record has been merged.");
      } else if (numOfMerge.equals(1)) {
        // empty
      } else {
        dbError("Multiple records have been merged.");
      }
    } catch (Exception e) {
      throw (BusinessException) RepositoryErrorHandler.handle(e, dataObject, errorCodes);
    }
  }

  protected <T> T handleFindOneResult(
      Supplier<List<T>> supplier, Object dataObject, ConstraintErrorCode... errorCodes)
      throws BusinessException {
    try {
      final List<T> results = supplier.get();

      if (results.isEmpty()) {
        createEntityDoesNotExistError(dataObject);
      } else if (results.size() == 1) {
        return results.get(0);
      } else {
        dbError("Too many records were found.");
      }
      return null;
    } catch (Exception e) {
      throw (BusinessException) RepositoryErrorHandler.handle(e, dataObject, errorCodes);
    }
  }

  protected static void dbError(String message) {
    throw DbErrorCode.DB_ERROR.createError(message).convertToException();
  }

  protected abstract void createEntityDoesNotExistError(Object id);
}
