package sk.kosice.konto.kknotificationservice.config.error;

import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public enum BusinessConfigErrorCode implements ErrorCode {
  UNDEFINED_EMAIL_SENDER(ErrorCodeType.INTERNAL, "Email sender address is not defined."),
  UNDEFINED_EMAIL_SENDER_NAME(ErrorCodeType.INTERNAL, "Email sender address is not defined."),
  UNDEFINED_MESSAGES_LIMIT(ErrorCodeType.INTERNAL, "Messages limit is not defined."),
  UNDEFINED_ADMIN_ROLE_ID(ErrorCodeType.INTERNAL, "Admin role id is not defined.");

  private final ErrorCodeType type;
  private final String template;

  BusinessConfigErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
