package sk.kosice.konto.kknotificationservice.message;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

import org.junit.jupiter.api.Test;

public class CreateEmailFromMessageFeatureSpec extends MessageFeatureSpec {

  @Test
  public void thatMessagesCanBeConvertedToEmails() {
    prepareMessages();

    final var messages = queryMessagePort.findNotSentMessages(100);
    assertThat(messages).isNotNull();
    assertThat(messages.size()).isEqualTo(2);

    final var emails =
        messages.stream().map(message -> createEmailFromMessageUseCase.execute(message)).toList();
    assertThat(emails).isNotNull();
    assertThat(emails.size()).isEqualTo(2);
  }
}
