package sk.kosice.konto.kknotificationservice.recipient;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static sk.kosice.konto.kknotificationservice.domain.recipient.error.RecipientErrorCode.RECIPIENT_DOES_NOT_EXIST;
import static sk.kosice.konto.kknotificationservice.recipient.RecipientApiFixtures.createOrUpdateRecipientRequest;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.RecipientDetailResponse;

public class RecipientDetailFeatureSpec extends RecipientFeatureSpec {

  @Test
  public void thatRecipientCanBeRetrieved() {
    final RecipientDetailResponse created =
        createOrUpdateRecipient(UUID.randomUUID(), createOrUpdateRecipientRequest());

    final RecipientDetailResponse detailResponse =
        getRecipient(created.kid(), HttpStatus.OK, RecipientDetailResponse.class);

    assertThat(detailResponse.kid()).isEqualTo(created.kid());
    assertThat(detailResponse.getPreferredEmail()).isEqualTo(created.getPreferredEmail());
  }

  @Test
  public void thatNotExistingRecipientCannotBeRetrieved() {
    final ErrorDetailResponse errorResponse =
        getRecipient(UUID.randomUUID(), HttpStatus.NOT_FOUND, ErrorDetailResponse.class);

    assertThat(errorResponse).isNotNull();
    assertThat(errorResponse.primaryFault().get().faultCode())
        .isEqualTo(RECIPIENT_DOES_NOT_EXIST.toString());
    assertThat(errorResponse.correlationId()).isNotEmpty();
  }
}
